/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.cdatetime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.nebula.cwt.v.VButton;
import org.eclipse.nebula.cwt.v.VControl;
import org.eclipse.nebula.cwt.v.VGridLayout;
import org.eclipse.nebula.cwt.v.VLabel;
import org.eclipse.nebula.cwt.v.VLayout;
import org.eclipse.nebula.cwt.v.VNative;
import org.eclipse.nebula.cwt.v.VPanel;
import org.eclipse.nebula.widgets.cdatetime.Body;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.nebula.widgets.cdatetime.CDateTimeBuilder;
import org.eclipse.nebula.widgets.cdatetime.CDateTimePainter;
import org.eclipse.nebula.widgets.cdatetime.Header;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CDatePanel
extends Composite {
    private VPanel panel;
    private VPanel header;
    private VPanel body;
    private List<VNative<CDateTime>> pickers;
    private int headerSize;
    private int pickerSize;
    private CDateTimeBuilder builder;
    private CDateTimePainter painter;
    private Locale locale;
    private TimeZone timezone;
    private Calendar calendar;
    private SelectionAdapter listener = new SelectionAdapter(){

        public void widgetDefaultSelected(SelectionEvent e) {
            CDateTime cdt = (CDateTime)e.widget;
            for (VNative picker : CDatePanel.this.pickers) {
                if (picker.getControl() == e.widget) continue;
                ((CDateTime)picker.getControl()).setSelection(cdt.getSelection());
            }
        }
    };

    public CDatePanel(Composite parent, int style) {
        super(parent, style);
        this.panel = new VPanel((Composite)this, 0);
        this.locale = Locale.getDefault();
        try {
            this.timezone = TimeZone.getDefault();
        }
        catch (Exception exception) {
            this.timezone = TimeZone.getTimeZone("GMT");
        }
        this.calendar = Calendar.getInstance(this.timezone, this.locale);
        this.calendar.setTime(new Date());
        this.builder = new CDateTimeBuilder();
        this.builder.setHeader(Header.Month().align(131072, 4, true).readOnly(), Header.Year().align(16384, 4, true).readOnly());
        this.builder.setBody(Body.Days().compact());
        this.painter = new CDateTimePainter(){

            protected void paintDayPanelBorders(VControl control, Event e) {
                Rectangle r = control.getBounds();
                e.gc.setForeground(e.display.getSystemColor(18));
                e.gc.drawLine(r.x, r.y, r.x, r.y + r.height - 1);
                e.gc.drawLine(r.x + r.width - 1, r.y, r.x + r.width - 1, r.y + r.height - 1);
                e.gc.drawLine(r.x, r.y + r.height - 1, r.x + r.width - 1, r.y + r.height - 1);
            }
        };
        this.pickers = new ArrayList<VNative<CDateTime>>();
        this.pickerSize = -1;
        VGridLayout layout = new VGridLayout();
        layout.verticalSpacing = 2;
        this.panel.setLayout((VLayout)layout);
        this.createHeader();
        VLabel sep = new VLabel(this.panel, 258);
        sep.setLayoutData(new GridData(4, 4, false, false));
        this.body = new VPanel(this.panel, 0);
        this.body.setLayout((VLayout)new VGridLayout());
        this.body.setLayoutData(new GridData(4, 4, true, true));
        this.body.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                CDatePanel.this.handleResize();
            }
        });
    }

    private void addMonth() {
        VNative picker = VNative.create(CDateTime.class, (VPanel)this.body, (int)0x40000004);
        picker.setLayoutData(new GridData(4, 128, true, false));
        CDateTime cdt = (CDateTime)picker.getControl();
        cdt.setBuilder(this.builder);
        cdt.setPainter(this.painter);
        cdt.setPattern("MMMM d yyyy");
        cdt.setLocale(this.locale);
        cdt.setTimeZone(this.timezone);
        cdt.setScrollable(false);
        cdt.addSelectionListener((SelectionListener)this.listener);
        this.pickers.add((VNative<CDateTime>)picker);
        this.updateMonths();
    }

    private void createHeader() {
        this.header = new VPanel(this.panel, 0);
        VGridLayout layout = new VGridLayout(3, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.header.setLayout((VLayout)layout);
        this.header.setLayoutData(new GridData(4, 128, false, false));
        VButton b = new VButton(this.header, 540676);
        b.setFill(this.getDisplay().getSystemColor(15));
        b.setLayoutData(new GridData(4, 4, false, false));
        b.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CDatePanel.this.calendar.add(2, -1);
                CDatePanel.this.updateMonths();
            }
        });
        b = new VButton(this.header, 524296);
        b.setText("Today");
        b.setLayoutData(new GridData(4, 4, true, false));
        b.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CDatePanel.this.calendar.setTimeInMillis(System.currentTimeMillis());
                CDatePanel.this.updateMonths();
            }
        });
        b = new VButton(this.header, 655364);
        b.setFill(this.getDisplay().getSystemColor(15));
        b.setLayoutData(new GridData(4, 4, false, false));
        b.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CDatePanel.this.calendar.add(2, 1);
                CDatePanel.this.updateMonths();
            }
        });
        this.headerSize = this.header.computeSize((int)-1, (int)-1).y;
    }

    public VPanel getPanel() {
        return this.panel;
    }

    private void handleResize() {
        if (this.pickerSize == -1) {
            this.setMonthCount(1);
            this.pickerSize = this.pickers.get((int)0).computeSize((int)-1, (int)-1).y;
        }
        int height = this.getClientArea().height;
        int count = (int)Math.ceil((double)(height - this.headerSize) / (double)this.pickerSize);
        this.setMonthCount(count);
    }

    private void removeMonth() {
        if (!this.pickers.isEmpty()) {
            VNative<CDateTime> picker = this.pickers.remove(this.pickers.size() - 1);
            picker.dispose();
        }
    }

    public void setMonthCount(int count) {
        while (count > this.pickers.size()) {
            this.addMonth();
        }
        while (count < this.pickers.size()) {
            this.removeMonth();
        }
    }

    private void updateMonths() {
        Calendar tmpcal = Calendar.getInstance(this.timezone, this.locale);
        tmpcal.setTime(this.calendar.getTime());
        for (VNative<CDateTime> picker : this.pickers) {
            ((CDateTime)picker.getControl()).show(tmpcal.getTime());
            tmpcal.add(2, 1);
        }
    }
}

